/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.signals.Signals;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportTruststoreUpdatedAction
extends TransportNodesAction<TruststoreUpdatedRequest, TruststoreUpdatedResponse, NodeRequest, NodeResponse> {
    private static final Logger log = LogManager.getLogger(TransportTruststoreUpdatedAction.class);
    private final TrustManagerRegistry trustManagerRegistry;

    @Inject
    public TransportTruststoreUpdatedAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Signals signals) {
        super("cluster:admin:searchguard:signals:truststores/update", threadPool, clusterService, transportService, actionFilters, TruststoreUpdatedRequest::new, NodeRequest::new, "management", NodeResponse.class);
        this.trustManagerRegistry = Objects.requireNonNull(signals.getTruststoreRegistry(), "Truststore registry is required");
    }

    protected TruststoreUpdatedResponse newResponse(TruststoreUpdatedRequest request, List<NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new TruststoreUpdatedResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodeRequest newNodeRequest(TruststoreUpdatedRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    protected NodeResponse nodeOperation(NodeRequest request) {
        DiscoveryNode localNode = this.clusterService.localNode();
        log.info("Local node '{}' received notification about truststore update '{}'.", (Object)localNode.getName(), (Object)request);
        String truststoreId = request.getTruststoreId();
        try {
            this.trustManagerRegistry.onTruststoreUpdate(truststoreId, request.getOperationType());
            return new NodeResponse(localNode);
        }
        catch (Exception ex) {
            String message = "Cannot update trust managers for trust store '" + truststoreId + "'. ";
            log.error(message, (Throwable)ex);
            return new NodeResponse(localNode, message + ex.getMessage());
        }
    }

    public static class TruststoreUpdatedResponse
    extends BaseNodesResponse<NodeResponse> {
        public TruststoreUpdatedResponse(StreamInput in) throws IOException {
            super(in);
        }

        public TruststoreUpdatedResponse(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class TruststoreUpdatedRequest
    extends BaseNodesRequest<TruststoreUpdatedRequest> {
        private final String truststoreId;
        private final String operationType;

        protected TruststoreUpdatedRequest(StreamInput in) throws IOException {
            super(in);
            this.truststoreId = in.readString();
            this.operationType = in.readString();
        }

        public TruststoreUpdatedRequest(String truststoreId, String operationType) {
            super(new String[0]);
            this.truststoreId = Objects.requireNonNull(truststoreId, "Truststore id is required");
            this.operationType = Objects.requireNonNull(operationType, "Operation type is required");
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.truststoreId);
            out.writeString(this.operationType);
        }

        public String getTruststoreId() {
            return this.truststoreId;
        }

        public String getOperationType() {
            return this.operationType;
        }

        public String toString() {
            return "TruststoreUpdatedRequest{truststoreId='" + this.truststoreId + '\'' + ", operationType='" + this.operationType + '\'' + '}';
        }
    }

    public static class TruststoreUpdatedActionType
    extends ActionType<TruststoreUpdatedResponse> {
        public static final String NAME = "cluster:admin:searchguard:signals:truststores/update";
        public static final TruststoreUpdatedActionType INSTANCE = new TruststoreUpdatedActionType();

        protected TruststoreUpdatedActionType() {
            super(NAME, TruststoreUpdatedResponse::new);
        }

        public static ActionFuture<TruststoreUpdatedResponse> send(Client client, String truststoreId, String operationType) {
            Objects.requireNonNull(client, "Client is required to send action cluster:admin:searchguard:signals:truststores/update");
            return client.execute((ActionType)INSTANCE, (ActionRequest)new TruststoreUpdatedRequest(truststoreId, operationType));
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final boolean success;
        private final String message;

        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.success = in.readBoolean();
            this.message = in.readOptionalString();
        }

        public NodeResponse(DiscoveryNode node) {
            super(node);
            this.success = true;
            this.message = null;
        }

        public NodeResponse(DiscoveryNode node, String errorMessage) {
            super(node);
            this.success = false;
            this.message = errorMessage;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.success);
            out.writeOptionalString(this.message);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private final TruststoreUpdatedRequest request;

        public NodeRequest(StreamInput streamInput) throws IOException {
            super(streamInput);
            this.request = new TruststoreUpdatedRequest(streamInput);
        }

        public NodeRequest(TruststoreUpdatedRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }

        public String getTruststoreId() {
            return this.request.getTruststoreId();
        }

        public String getOperationType() {
            return this.request.getOperationType();
        }

        public String toString() {
            return "NodeRequest{request=" + (Object)((Object)this.request) + '}';
        }
    }
}

